from time import *
from Components.ActionMap import *
from Components.Label import Label
from Components.MenuList import MenuList
from Components.MultiContent import MultiContentEntryText, MultiContentEntryPixmap, MultiContentEntryPixmapAlphaTest, MultiContentTemplateColor
from Components.config import config
from Components.ScrollLabel import ScrollLabel
from enigma import ePicLoad
from Tools.LoadPixmap import LoadPixmap
from Tools.BoundFunction import boundFunction
from Components.Pixmap import Pixmap
from Components.AVSwitch import AVSwitch
from Screens.InfoBar import *
from Components.PluginComponent import plugins
from Components.Button import Button
from Screens.Screen import Screen
from Screens.MessageBox import MessageBox
from Plugins.Plugin import PluginDescriptor
from twisted.web.client import getPage
from twisted.web.client import downloadPage
from urllib import unquote_plus
from urllib2 import Request, urlopen, URLError
from urlparse import parse_qs
import httplib, os, re, socket, sys, time, urllib
from Components.ServicePosition import ServicePositionGauge
from Tools.NumericalTextInput import NumericalTextInput
from Components.ConfigList import *
from Components.config import *
from Components.ConfigList import ConfigList, ConfigListScreen
from Components.config import config, ConfigSubsection, ConfigText, getConfigListEntry, ConfigSelection
from Screens.HelpMenu import HelpableScreen
from Screens.InputBox import InputBox
from Screens.ChoiceBox import ChoiceBox
from Screens.Screen import Screen
from re import findall, match, search, split, sub
from enigma import eListboxPythonMultiContent, eListbox, gFont, RT_HALIGN_LEFT, RT_HALIGN_RIGHT, RT_HALIGN_CENTER, loadPNG, RT_WRAP, eServiceReference, getDesktop, loadJPG, RT_VALIGN_CENTER, gPixmapPtr, ePicLoad, loadPic
from Tools.Directories import pathExists, fileExists, SCOPE_SKIN_IMAGE, resolveFilename
import sys, os, base64, re, time, skin, datetime
from twisted.web import client, error as weberror
from twisted.internet import reactor
from twisted.internet import defer
from urllib import urlencode
from time import strptime, mktime, localtime, strftime
from skin import parseColor
import time
import datetime
from datetime import timedelta
from zapisession import ZapiSession
import urllib, urllib2
from os import popen as os_popen
from enigma import eConsoleAppContainer
from Screens.Console import Console

config.plugins.zattoo = ConfigSubsection()
config.plugins.zattoo.username = ConfigText(default='', fixed_size=False)
config.plugins.zattoo.password = ConfigText(default='', fixed_size=False)
config.plugins.zattoo.style = ConfigSelection(default='blue', choices=[('black', _('Black')), ('blue', _('Blue'))])
config.plugins.zattoo.maxrate = ConfigSelection(default='5000', choices=[('1500', _('432p25 SD')),
 ('2999', _('576p50 SD')),
 ('3000', _('720p25 HD')),
 ('5000', _('720p50 HD')),
 ('4999', _('1080p25 FHD')),
 ('8000', _('1080p50 FHD'))])
config.plugins.zattoo.channels = ConfigSelection(default='ALL', choices=[('All', _('all Channels')), ('FAV', _('only Favorites'))])
config.plugins.zattoo.picons = ConfigSelection(default='black', choices=[('black', _('Black')), ('white', _('White'))])
config.plugins.zattoo.savepicon = ConfigText(default='/media/hdd/zattoo/', fixed_size=False)
config.plugins.zattoo.savedl = ConfigText(default='/media/hdd/movie/', fixed_size=False)
config.plugins.zattoo.abc = ConfigSelection(default='az', choices=[('normal', _('normal')), ('az', _('az'))])
pname = 'Zattoo'
pversion = 'v3.5'
pdate = '20215019'
screensize = getDesktop(0).size().height()

class zattooMain(Screen):
    if screensize <= 720:
        skin = '\n\t\t        <screen name="Zattoo" position="0,0" size="1280,720" title=" " backgroundColor="transparent" flags="wfNoBorder" zPosition="10">\n                        <widget name="cover" position="949,118" size="267,188" alphatest="blend" zPosition="25" />\n                        <widget name="now_title" position="381,532" size="833,35" font="THDRegular2; 28" halign="left" backgroundColor="#2d476f" shadowColor="#000000" shadowOffset="-1,-1" transparent="1" zPosition="10" />\n                        <widget name="next_title" position="381,577" size="833,35" font="THDRegular2; 28" halign="left" backgroundColor="#2d476f" shadowColor="#000000" shadowOffset="-1,-1" transparent="1" zPosition="10" />\n                        <widget name="picon" position="75,528" size="113,85" zPosition="5" transparent="1" alphatest="blend" /> \n                        <widget name="now_time" position="206,536" size="157,24" font="THDRegular2;21" halign="left" backgroundColor="#2d476f" shadowColor="#000000" shadowOffset="-1,-1" transparent="1" zPosition="14" />\n                        <widget name="next_time" position="206,584" size="157,24" font="THDRegular2;21" halign="left" backgroundColor="#2d476f" shadowColor="#000000" shadowOffset="-1,-1" transparent="1" zPosition="14" />\n                        <eLabel position="0,521" size="1280,96" zPosition="2" backgroundColor="#657086" />\n                        <widget name="list" position="20,109" size="1240,415" zPosition="15" transparent="1" scrollbarWidth="5" />\n                        <widget name="extended" backgroundColor="#0b1a24" position="20,109" size="920,415" font="THDRegular2;28" zPosition="20" transparent="1" scrollbarWidth="5" valign="top" halign="left" />\n                        <ePixmap position="45,30" zPosition="4" size="75,70" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/pic/zattoo.png" transparent="1" alphatest="blend" />\n                        <widget source="global.CurrentTime" render="Label" shadowColor="#000000" shadowOffset="3,2" zPosition="5" position="1080,57" size="103,50" font="THDRegular; 28" halign="right" backgroundColor="#000000" transparent="1">\n                                <convert type="ClockToText">Default</convert>\n                        </widget>\n                        <widget source="global.CurrentTime" render="Label" shadowColor="#000000" shadowOffset="3,2" zPosition="5" position="897,57" size="43,30" font="THDRegular; 28" halign="left" backgroundColor="#000000" transparent="1">\n                                <convert type="ClockToText">Date</convert>\n                        </widget>\n                        <widget source="global.CurrentTime" render="Label" shadowColor="#000000" shadowOffset="3,2" zPosition="5" position="937,57" size="157,50" font="THDRegular; 28" halign="right" backgroundColor="#000000" transparent="1">\n                                <convert type="ClockToText">Format:%d.%m.%Y</convert>\n                        </widget>\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/menu.png" zPosition="4" position="1062,634" size="80,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/red.png" zPosition="4" position="97,634" size="40,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/green.png" zPosition="4" position="309,634" size="40,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/yellow.png" zPosition="4" position="514,634" size="40,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/blue.png" zPosition="4" position="721,634" size="40,40" alphatest="blend" />\n                        <widget name="key_red" position="135,637" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget name="key_green" position="342,637" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget name="key_yellow" position="546,637" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget name="key_blue" position="756,637" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />  \n                        <widget source="Title" render="Label" shadowColor="#000000" shadowOffset="3,2" position="141,57" zPosition="5" size="588,40" font="THDRegular; 28" backgroundColor="#000000" transparent="1" />\n                        '
        if config.plugins.zattoo.style.value == 'blue':
            skin += '\n                                <ePixmap position="0,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                                <ePixmap position="0,618" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                                <eLabel position="0,102" size="1280,519" zPosition="2" backgroundColor="#0b1a24" />\n                                <eLabel position="0,526" size="1280,97" zPosition="4" backgroundColor="#2d476f" />        \n                                </screen>'
        else:
            skin += '\n                                <ePixmap position="0,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlongBlack.png" transparent="1" />\n                                <ePixmap position="0,618" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlongBlack.png" transparent="1" />\n                                <eLabel position="0,102" size="1280,519" zPosition="2" backgroundColor="#111111" />\n                                <eLabel position="0,526" size="1280,97" zPosition="4" backgroundColor="#222222" />        \n                                </screen>'
    else:
        skin = '     \n                        <screen name="Zattoo" position="0,0" size="1920,1080" title=" " backgroundColor="transparent" flags="wfNoBorder" zPosition="10">\n                        <widget name="cover" position="1375,130" size="485,378" alphatest="blend" zPosition="25" />\n                        <widget name="now_title" position="535,874" size="1270,47" font="THDRegular2; 33" halign="left" backgroundColor="#2d476f" shadowColor="#000000" shadowOffset="-1,-1" transparent="1" zPosition="10" />\n                        <widget name="next_title" position="535,929" size="1270,47" font="THDRegular2; 33" halign="left" backgroundColor="#2d476f" shadowColor="#000000" shadowOffset="-1,-1" transparent="1" zPosition="10" />\n                        <widget name="picon" position="59,870" size="149,105" zPosition="5" transparent="1" alphatest="blend" /> \n                        <widget name="now_time" position="296,882" size="195,36" font="THDRegular2;25" halign="left" backgroundColor="#2d476f" shadowColor="#000000" shadowOffset="-1,-1" transparent="1" zPosition="14" />\n                        <widget name="next_time" position="296,932" size="195,36" font="THDRegular2;25" halign="left" backgroundColor="#2d476f" shadowColor="#000000" shadowOffset="-1,-1" transparent="1" zPosition="14" />\n                        <eLabel position="0,866" size="1922,96" zPosition="2" backgroundColor="#657086" />\n                        <widget name="list" position="18,109" size="1886,748" zPosition="15" transparent="1" scrollbarWidth="5" />\n                        <widget name="extended" backgroundColor="#0b1a24" position="20,109" size="1312,748" font="THDRegular2;37" zPosition="20" transparent="1" scrollbarWidth="5" valign="top" halign="left" />\n                        <ePixmap position="45,30" zPosition="4" size="75,70" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/pic/zattoo.png" transparent="1" alphatest="blend" />\n                        <ePixmap position="0,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                        <ePixmap position="1280,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                        <ePixmap position="0,982" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                        <ePixmap position="1280,982" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                        <eLabel position="0,98" size="1920,843" zPosition="2" backgroundColor="#0b1a24" />\n                        <eLabel position="0,866" size="1922,121" zPosition="4" backgroundColor="#2d476f" />\n                        <widget source="global.CurrentTime" render="Label" shadowColor="#000000" shadowOffset="3,2" zPosition="5" position="1710,55" size="103,50" font="THDRegular; 28" halign="right" backgroundColor="#000000" transparent="1">\n                                <convert type="ClockToText">Default</convert>\n                        </widget>\n                        <widget source="global.CurrentTime" render="Label" shadowColor="#000000" shadowOffset="3,2" zPosition="5" position="1529,55" size="43,30" font="THDRegular; 28" halign="left" backgroundColor="#000000" transparent="1">\n                                <convert type="ClockToText">Date</convert>\n                        </widget>\n                        <widget source="global.CurrentTime" render="Label" shadowColor="#000000" shadowOffset="3,2" zPosition="5" position="1567,55" size="157,50" font="THDRegular; 28" halign="right" backgroundColor="#000000" transparent="1">\n                                <convert type="ClockToText">Format:%d.%m.%Y</convert>\n                        </widget>\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/menu.png" zPosition="4" position="1438,995" size="80,40" alphatest="blend" />  \n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/red.png" zPosition="4" position="211,995" size="40,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/green.png" zPosition="4" position="483,995" size="40,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/yellow.png" zPosition="4" position="728,995" size="40,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/blue.png" zPosition="4" position="965,995" size="40,40" alphatest="blend" />\n                        <widget name="key_red" position="275,997" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget name="key_green" position="544,997" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget name="key_yellow" position="782,997" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget name="key_blue" position="1016,997" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget source="Title" render="Label" shadowColor="#000000" shadowOffset="3,2" position="141,57" zPosition="5" size="588,40" font="THDRegular; 28" backgroundColor="#000000" transparent="1" />\n                        '
        if config.plugins.zattoo.style.value == 'blue':
            skin += '\n                                <ePixmap position="0,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                                <ePixmap position="1280,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                                <ePixmap position="0,982" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                                <ePixmap position="1280,982" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                                <eLabel position="0,98" size="1920,843" zPosition="2" backgroundColor="#0b1a24" />\n                                <eLabel position="0,866" size="1922,121" zPosition="4" backgroundColor="#2d476f" />        \n                                </screen>'
        else:
            skin += '\n                                <ePixmap position="0,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlongBlack.png" transparent="1" />\n                                <ePixmap position="1280,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlongBlack.png" transparent="1" />\n                                <ePixmap position="0,982" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlongBlack.png" transparent="1" />\n                                <ePixmap position="1280,982" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlongBlack.png" transparent="1" />\n                                <eLabel position="0,98" size="1920,843" zPosition="2" backgroundColor="#111111" />\n                                <eLabel position="0,866" size="1922,121" zPosition="4" backgroundColor="#222222" />        \n                                </screen>'

    def __init__(self, session):
        from enigma import addFont
        addFont('/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/font/technihd.ttf', 'THDRegular', 100, 1)
        addFont('/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/font/technihd2.ttf', 'THDRegular2', 100, 1)
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ShortcutActions',
         'WizardActions',
         'ColorActions',
         'SetupActions',
         'NumberActions',
         'MenuActions',
         'EPGSelectActions',
         'InfobarInstantRecord'], {'cancel': self.keyCancel,
         'red': self.keyRecord,
         'instantRecord': self.keyRecord,
         'info': self.eventInfo,
         'green': self.reloadlist,
         'menu': self.keyMainMenu,
         'ok': self.keyOk,
         'up': self.keyUp,
         'down': self.keyDown,
         'nextBouquet': self.keyUp,
         'prevBouquet': self.keyDown,
         'left': self.keyLeft,
         'right': self.keyRight,
         'yellow': self.listRecordings,
         'blue': self.keySetup}, -1)
        self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
        if screensize <= 720:
            font1, size1 = skin.parameters.get('ZattooListFont1', ('THDRegular', 24))
            font2, size2 = skin.parameters.get('ZattooListFont2', ('THDRegular2', 21))
            font3, size3 = skin.parameters.get('ZattooListFont3', ('THDRegular2', 20))
            self.itemheight = int(skin.parameters.get('ZattooListItemHeight', (59,))[0])
            self.listwidth = int(skin.parameters.get('ZattooListWidth', (450,))[0])
        else:
            font1, size1 = skin.parameters.get('ZattooListFont1', ('THDRegular', 33))
            font2, size2 = skin.parameters.get('ZattooListFont2', ('THDRegular2', 29))
            font3, size3 = skin.parameters.get('ZattooListFont3', ('THDRegular2', 22))
            self.itemheight = int(skin.parameters.get('ZattooListItemHeight', (82,))[0])
            self.listwidth = int(skin.parameters.get('ZattooListWidth', (600,))[0])
        self.chooseMenuList.l.setFont(0, gFont(font1, int(size1)))
        self.chooseMenuList.l.setFont(1, gFont(font2, int(size2)))
        self.chooseMenuList.l.setFont(2, gFont(font3, int(size3)))
        self.chooseMenuList.l.setItemHeight(self.itemheight)
        self.chooseMenuList.selectionEnabled(False)
        self['info'] = Label('Info')
        self['list'] = self.chooseMenuList
        self['picon'] = Pixmap()
        self['now_time'] = Label(' ')
        self['now_title'] = Label(' ')
        self['next_time'] = Label(' ')
        self['next_title'] = Label(' ')
        self['extended'] = ScrollLabel()
        self['extended'].hide()
        self['key_red'] = Label(_('REC'))
        self['key_green'] = Label(_('Update'))
        self['key_blue'] = Label(_('Setup'))
        self['key_yellow'] = Label(_('Aufnahmen'))
        self['cover'] = Pixmap()
        self['cover'].hide()
        self.list = []
        self.listb = []
        self.extended = []
        self.lastservice = self.session.nav.getCurrentlyPlayingServiceReference()
        self.title = 'Zattoo'
        self.login = False
        self.playing = False
        self.zapi = ZapiSession('/usr/lib/enigma2/python/Plugins/Extensions/zattoo/')
        self.AccountData = None
        self.showlist = False
        self.eventInfos = False
        self.onClose.append(self.__onClose)
        self.onLayoutFinish.append(self.dologin)
        return

    def setinfo(self, txt):
        self['info'].setText(txt)

    def setInfoBar(self):
        exist = self['list'].getCurrent()
        if exist == None:
            return
        else:
            chname = self['list'].getCurrent()[0][1]
            picon = self['list'].getCurrent()[0][2]
            now_time = self['list'].getCurrent()[0][3]
            now_title = self['list'].getCurrent()[0][4]
            next_time = self['list'].getCurrent()[0][5]
            next_title = self['list'].getCurrent()[0][6]
            eventid = self['list'].getCurrent()[0][7]
            self.loadPicon(picon)
            self['now_time'].setText(now_time)
            self['now_title'].setText(now_title)
            self['next_time'].setText(next_time)
            self['next_title'].setText(next_title)
            return

    def dologin(self):
        self.setinfo('Login...!')
        if not pathExists(config.plugins.zattoo.savepicon.value):
            os.makedirs(config.plugins.zattoo.savepicon.value)
        if config.plugins.zattoo.username.value == '' and config.plugins.zattoo.password.value == '':
            self.setinfo('Bitte > MENU < dr\xc3\xbccken und Login daten eingeben.')
        else:
            self.login = self.zapi.init_session(config.plugins.zattoo.username.value, config.plugins.zattoo.password.value)
            if self.login:
                try:
                    self.setinfo('Login ok !')
                    self.AccountData = self.zapi.get_accountData()
                    api = '/zapi/v2/cached/channels/' + self.AccountData['session']['power_guide_hash'] + '?details=True'
                    #api = '/zapi/v3/cached/' + self.AccountData['power_guide_hash'] + '/channels?'
                    channelsData = self.zapi.exec_zapiCall(api, None)
                    print channelsData 
                    api2 = '/zapi/channels/favorites'
                    favoritesData = self.zapi.exec_zapiCall(api2, None)
                    count = 0
                    for groups in channelsData['channel_groups']:
                        for each in groups['channels']:
                            chname = str(each['title']).replace(' Deutschland', '').replace(' Schweiz', '').replace('Pro7', 'ProSieben').replace('Pro7 HD', 'ProSieben HD').replace('RTL II HD', 'RTLII HD')
                            eventid = str(each['id'][0])
                            cid = str(each['cid'])
                            if len(each['qualities']) > 1:
                                availability = each['qualities'][1]['availability']
                            else:
                                availability = each['qualities'][0]['availability']
                            logoname = cid
                            if config.plugins.zattoo.picons.value == 'white':
                                logourl = 'https://logos.zattic.com' + str(each['qualities'][0]['logo_black_84'])
                            if config.plugins.zattoo.picons.value == 'black':
                                logourl = 'https://logos.zattic.com' + str(each['qualities'][0]['logo_white_84'])
                            logopath = config.plugins.zattoo.savepicon.value + logoname + '.png'
                            if not fileExists(logopath):
                                downloadPage(logourl, logopath)
                            now_title = ''
                            now_time = ''
                            next_title = ''
                            next_time = ''
                            if 'now' in each:
                                if each['now'] is not None:
                                    timestart = str(each['now']['s'])
                                    timeend = str(each['now']['e'])
                                    programid = str(each['now']['id'])
                                    now_title = chname + ' - ' + ' (' + str(each['now']['t']) + ')'
                                    now_time = self.getHours(str(each['now']['s'])) + ' - ' + self.getHours(str(each['now']['e']))
                                else:
                                    now_title = chname + ' -  ' + _('No description available.')
                                    next_title = _('No description available.')
                                    now_time = '00:00 - 00:00'
                                    next_time = '00:00 - 00:00'
                                    programid = 'Keine Ahnung'
                            if 'next' in each:
                                if each['next'] is not None:
                                    next_title = str(each['next']['t'])
                                    next_time = self.getHours(str(each['next']['s']))
                                    next_time += ' - ' + self.getHours(str(each['next']['e']))
                                else:
                                    now_title = chname + ' -  ' + _('No description available.')
                                    next_title = _('No description available.')
                                    now_time = '00:00 - 00:00'
                                    next_time = '00:00 - 00:00'
                            if channelsData:
                                count = len(self.list)
                                count += 1
                                nr = str(count) + '.'
                            if config.plugins.zattoo.channels.value == 'FAV':
                                if favoritesData:
                                    self.setTitle('Zattoo - Favoriten')
                                    for entry in favoritesData['favorites']:
                                        favorite = str(entry)
                                        if favorite == cid:
                                            cid = str(favorite)
                                            self.list.append((chname,
                                             cid,
                                             logopath,
                                             now_time,
                                             now_title,
                                             next_time,
                                             next_title,
                                             eventid,
                                             programid,
                                             timestart,
                                             timeend,
                                             nr,
                                             availability))

                            else:
                                self.setTitle('Zattoo')
                                self.list.append((chname,
                                 cid,
                                 logopath,
                                 now_time,
                                 now_title,
                                 next_time,
                                 next_title,
                                 eventid,
                                 programid,
                                 timestart,
                                 timeend,
                                 nr,
                                 availability))

                    self.chooseMenuList.setList(map(self.showList, self.list))
                    self.showlist = True
                    self.setInfoBar()
                    self.setinfo('Senderliste')
                except:
                    self.setinfo('Plugin Entwickler kontaktieren !')

            else:
                self.setinfo('Login failed !')
        return

    def getHours(self, unixtime):
        return datetime.datetime.fromtimestamp(int(unixtime)).strftime('%H:%M')

    def showList(self, entry):
        chname, cid, logopath, now_time, now_title, next_time, next_title, eventid, programid, timestart, timeend, nr, availability = entry
        callback = [entry]
        if fileExists(entry[2]):
            logo = loadPNG(entry[2])
            callback.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND,
             7,
             (self.itemheight - 44) / 3,
             100,
             self.itemheight,
             logo))
        if availability == 'subscribable':
            color = parseColor('#00636363').argb()
            colorblue = parseColor('#00dbf6ff').argb()
            callback.append((eListboxPythonMultiContent.TYPE_TEXT,
             106,
             13,
             45,
             self.itemheight / 2,
             2,
             RT_HALIGN_CENTER | RT_VALIGN_CENTER,
             entry[11],
             colorblue))
            key = loadPNG('/usr/lib/enigma2/python/Plugins/Extensions/zattoo/pic/key.png')
            if screensize <= 720:
                callback.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND,
                 1018,
                 (self.itemheight - 30) / 2,
                 30,
                 30,
                 key))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 160,
                 5,
                 920,
                 self.itemheight / 2,
                 0,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[4],
                 color))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 1070,
                 5,
                 300,
                 self.itemheight / 2,
                 1,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[3],
                 color))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 1070,
                 30,
                 300,
                 self.itemheight / 2,
                 1,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[5],
                 color))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 160,
                 32,
                 920,
                 self.itemheight / 2,
                 1,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[6],
                 color))
            else:
                callback.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND,
                 1590,
                 (self.itemheight - 30) / 2,
                 30,
                 30,
                 key))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 160,
                 5,
                 1520,
                 self.itemheight / 2,
                 0,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[4],
                 color))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 1640,
                 5,
                 300,
                 self.itemheight / 2,
                 1,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[3],
                 color))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 1640,
                 35,
                 300,
                 self.itemheight / 2,
                 1,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[5],
                 color))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 160,
                 38,
                 1520,
                 self.itemheight / 2,
                 1,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[6],
                 color))
        else:
            color = parseColor('#00fabe4b').argb()
            colorblue = parseColor('#00dbf6ff').argb()
            callback.append((eListboxPythonMultiContent.TYPE_TEXT,
             106,
             13,
             45,
             self.itemheight / 2,
             2,
             RT_HALIGN_CENTER | RT_VALIGN_CENTER,
             entry[11],
             colorblue))
            if screensize <= 720:
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 160,
                 5,
                 920,
                 self.itemheight / 2,
                 0,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[4]))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 1070,
                 5,
                 300,
                 self.itemheight / 2,
                 1,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[3]))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 1070,
                 30,
                 300,
                 self.itemheight / 2,
                 1,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[5],
                 color))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 160,
                 32,
                 920,
                 self.itemheight / 2,
                 1,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[6],
                 color))
            else:
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 160,
                 5,
                 1520,
                 self.itemheight / 2,
                 0,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[4]))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 1640,
                 5,
                 300,
                 self.itemheight / 2,
                 1,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[3]))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 1640,
                 35,
                 300,
                 self.itemheight / 2,
                 1,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[5],
                 color))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 160,
                 38,
                 1520,
                 self.itemheight / 2,
                 1,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[6],
                 color))
        return callback

    def __onClose(self):
        None
        return

    def loadPicon(self, poster_path):
        if fileExists(poster_path):
            self['picon'].instance.setPixmapFromFile(poster_path)
            self['picon'].instance.setScale(2)
            self['picon'].show()

    def listRecordings(self):
        self.session.open(zattooPlaylist)

    def eventInfo(self):
        if self.eventInfos == False:
            cid = self['list'].getCurrent()[0][1]
            eventid2 = self['list'].getCurrent()[0][8]
            eventid = str(eventid2)
            self.dstart = self['list'].getCurrent()[0][9]
            self.dend = self['list'].getCurrent()[0][10]
            url = 'https://zattoo.buehlmann.net/epg/api/Epg/CH/' + eventid + '/' + cid + '/' + self.dstart + '/' + self.dend
            print url
            try:
                getPage(url).addCallback(self.eventData).addErrback(self.dataError)
            except:
                pass

            self.show()
            self.showlist = True
            self['list'].hide()
            self['extended'].show()
            print cid
        else:
            self.eventInfos = False
            self['extended'].setText('')
            self['list'].show()
            self['extended'].hide()
            self['cover'].hide()
            self.show()
            self.showlist = True

    def eventData(self, data):
        if self.eventInfos == False:
            self.eventInfos = True
            urlepg = re.findall('Id":(.*?),"Title":".*?,"Subtitle', data, re.S)
            if urlepg:
                program = self['list'].getCurrent()[0][8]
                progid = str(program)
                print progid
                if progid:
                    self['list'].hide()
                    search = '.*?"Title":(.*?),"Subtitle":(.*?),"Genre":(.*?),"Description":(.*?),"StartTime":".*?T(.*?):*?","EndTime":".*?T(.*?):*?","ImageUrl":"htt.*?://images.zattic.com/cms/(.*?)/format_480x360.jpg"'
                    if urlepg:
                        if progid:
                            if str(urlepg[0]) == progid:
                                eventid = urlepg[0]
                            elif str(urlepg[1]) == progid:
                                eventid = urlepg[1]
                            elif str(urlepg[2]) == progid:
                                eventid = urlepg[2]
                            elif str(urlepg[3]) == progid:
                                eventid = urlepg[3]
                            elif str(urlepg[4]) == progid:
                                eventid = urlepg[4]
                            elif str(urlepg[5]) == progid:
                                eventid = urlepg[5]
                            elif str(urlepg[6]) == progid:
                                eventid = urlepg[6]
                            elif str(urlepg[7]) == progid:
                                eventid = urlepg[7]
                            elif str(urlepg[8]) == progid:
                                eventid = urlepg[8]
                            elif str(urlepg[9]) == progid:
                                eventid = urlepg[9]
                            else:
                                return
                            eventFind = re.findall(eventid + search, data, re.S)
                            for title, subtitle, genre, event, start, end, image in eventFind:
                                if str(subtitle) == 'null':
                                    subtitle = ''
                                else:
                                    subtitle = '\n\n(' + str(subtitle).replace('"', '') + ')'
                                if str(genre) == 'null':
                                    genre = ''
                                else:
                                    genre = '\xb7 ' + str(genre).replace('"', '') + ' \xb7'
                                if str(event) == 'null':
                                    event = 'Keine Information'
                                else:
                                    event = str(event).replace("'", '').replace('"', '').replace('\\', '').replace('\\u005C', '').replace('{', '').replace('}', '').replace('[', '').replace(']', '').replace('\\u00E4', '\xe4').replace('\\u00F6', '\xf6').replace('\\u00FC', '\xfc').replace('\\u00C4', '\xc4').replace('\\u00D6', '\xd6').replace('\\u00DC', '\xdc').replace('\\u00DF', '\xdf')
                                if str(title) == 'null':
                                    title = 'Keine Information'
                                else:
                                    title = str(title).replace("'", '').replace('"', '')
                                self['extended'].setText(title + '\n\n' + genre + subtitle + '\n\n' + event)
                                fiximage = 'https://images.zattic.com/cms/' + image + '/format_480x360.jpg'
                                try:
                                    downloadPage(fiximage, '/tmp/Icon.jpg').addCallback(self.showCover, '/tmp/Icon.jpg').addErrback(self.dataError)
                                except:
                                    pass

                    if progid:
                        self['extended'].show()
        else:
            self.eventInfos = False
            self['extended'].setText('')
            self['list'].show()
            self['cover'].hide()

    def showCover(self, data, poster_path):
        self.poster_path = poster_path
        self['cover'].instance.setPixmap(None)
        self['cover'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['cover'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(self.poster_path, 0, 0, False) == 0:
            print '2'
            ptr = self.picload.getData()
            if ptr != None:
                print '3'
                self['cover'].instance.setScale(2)
                self['cover'].instance.setPixmap(ptr)
                self['cover'].show()
        return

    def keyRecall(self):
        exist = self['list'].getCurrent()
        if exist == None:
            return
        else:
            if self.showlist:
                chname = self['list'].getCurrent()[0][0]
                id = self['list'].getCurrent()[0][8]
                stream = self.zapi.exec_zapiCall('/zapi/watch', {'cid': id,
                 'stream_type': 'hls',
                 'maxrate': config.plugins.zattoo.maxrate.value})
                print stream
                try:
                    stream_url = stream['stream']['watch_urls'][0]['url']
                    self.session.nav.stopService()
                    sref = eServiceReference(5001, 0, str(stream_url))
                    sref.setName(chname)
                    self.setTitle(chname)
                    self.session.nav.playService(sref)
                    self.playing = True
                    self.showlist = False
                    self.hide()
                except:
                    self.setinfo('Sender nicht gebucht !')

            else:
                self.show()
                self.showlist = True
            return

    def keyRecord(self):
        id = self['list'].getCurrent()[0][8]
        recording = self.zapi.exec_zapiCall('/zapi/playlist/program', {'program_id': id})
        if recording:
            self.session.open(MessageBox, _('Zattoo >> Aufnahme Hinzugef\xc3\xbcgt <<'), MessageBox.TYPE_INFO, timeout=8)

    def dataError(self, data):
        pass

    def keyMainMenu(self):
        from Screens.Menu import MainMenu
        from Tools.Directories import resolveFilename, SCOPE_SKIN
        import xml.etree.cElementTree
        mdom = xml.etree.cElementTree.parse(resolveFilename(SCOPE_SKIN, 'menu.xml'))
        menu = mdom.getroot()
        self.session.open(MainMenu, menu)

    def keyLeft(self):
        if self.eventInfos == True:
            self['extended'].pageUp()
        if self.showlist:
            self['list'].pageUp()
            if self.eventInfos == False:
                self.setInfoBar()
        else:
            self.showlist = True
            self.show()

    def keyRight(self):
        if self.eventInfos == True:
            self['extended'].pageDown()
        if self.showlist:
            self['list'].pageDown()
            if self.eventInfos == False:
                self.setInfoBar()
        else:
            self.showlist = True
            self.show()

    def switch(self):
        chname = self['list'].getCurrent()[0][0]
        id = self['list'].getCurrent()[0][1]
        stream = self.zapi.exec_zapiCall('/zapi/watch', {'cid': id,
         'stream_type': 'hls7',
         'maxrate': config.plugins.zattoo.maxrate.value})
        try:
            stream_url = stream['stream']['watch_urls'][0]['url']
            stream_url2 = stream_url.replace('-hls7', '-hls5')
            self.session.nav.stopService()
            sref = eServiceReference(4097, 2, str(stream_url2))
            sref.setName(chname)
            self.setTitle(chname)
            self.session.nav.playService(sref)
            self.playing = True
            self.showlist = False
            self.hide()
        except:
            self.setTitle('Sender nicht gebucht !')

    def keyUp(self):
        if self.eventInfos == True:
            self['extended'].pageUp()
        if self.showlist:
            self['list'].up()
            if self.eventInfos == False:
                self.setInfoBar()
        else:
            chname = self['list'].down()
            self.switch()

    def keyDown(self):
        if self.eventInfos == True:
            self['extended'].pageDown()
        if self.showlist:
            self['list'].down()
            if self.eventInfos == False:
                self.setInfoBar()
        else:
            chname = self['list'].up()
            self.switch()

    def keyOk(self):
        exist = self['list'].getCurrent()
        if exist == None:
            return
        else:
            if self.showlist:
                chname = self['list'].getCurrent()[0][0]
                id = self['list'].getCurrent()[0][1]
                stream = self.zapi.exec_zapiCall('/zapi/watch', {'cid': id,
                 'stream_type': 'hls7',
                 'maxrate': config.plugins.zattoo.maxrate.value, 'audio_channel': 'A'})
                print stream
                try:
                    stream_url = stream['stream']['watch_urls'][0]['url']
                    stream_url2 = stream_url.replace('-hls7', '-hls5')
                    self.session.nav.stopService()
                    sref = eServiceReference(4097, 2, str(stream_url2))
                    sref.setName(chname)
                    self.setTitle(chname)
                    self.session.nav.playService(sref)
                    self.playing = True
                    self.showlist = False
                    self.hide()
                except:
                    self.setinfo('Sender nicht gebucht !')

            else:
                self.show()
                self.showlist = True
            return

    def keySetup(self):
        self.session.openWithCallback(self.relogin, zattooSetup)

    def relogin(self, answer):
        if answer:
            self.dologin()

    def reloadlist(self):
        if self.showlist:
            self.list = []
            self.dologin()
        else:
            self.list = []
            self.dologin()
            self.showlist = False

    def keyCancel(self):
        if self.eventInfos == True:
            self.eventInfos = False
            self['extended'].setText('')
            self['list'].show()
            self['extended'].hide()
            self['cover'].hide()
            self.show()
            self.showlist = True
            return
        if self.showlist and self.playing:
            if self.eventInfos == True:
                self.eventInfos = False
                self['extended'].setText('')
                self['list'].show()
                self['extended'].hide()
                self['cover'].hide()
                self.show()
                self.showlist = True
                return
            else:
                self.hide()
                self.showlist = False
                return
        if self.playing:
            self.session.nav.stopService()
            self.session.nav.playService(self.lastservice)
            self.playing = False
            self.show()
            self.showlist = True
            return
        self.close()


class zattooSetup(Screen, ConfigListScreen):
    if screensize <= 720:
        skin = '\n                        <screen name="Zattoo Setup" position="0,0" size="1280,720" title="Zattoo - Einstellungen" backgroundColor="transparent" flags="wfNoBorder" zPosition="10">\n                        <widget name="config" itemHeight="50" position="20,109" size="1220,476" zPosition="15" transparent="1" scrollbarWidth="5" />\n                        <ePixmap position="45,30" zPosition="4" size="75,70" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/pic/zattoo.png" transparent="1" alphatest="blend" />\n                        <widget source="global.CurrentTime" render="Label" shadowColor="#000000" shadowOffset="3,2" zPosition="5" position="1080,57" size="103,50" font="THDRegular; 28" halign="right" backgroundColor="#000000" transparent="1">\n                                <convert type="ClockToText">Default</convert>\n                        </widget>\n                        <widget source="global.CurrentTime" render="Label" shadowColor="#000000" shadowOffset="3,2" zPosition="5" position="897,57" size="43,30" font="THDRegular; 28" halign="left" backgroundColor="#000000" transparent="1">\n                                <convert type="ClockToText">Date</convert>\n                        </widget>\n                        <widget source="global.CurrentTime" render="Label" shadowColor="#000000" shadowOffset="3,2" zPosition="5" position="937,57" size="157,50" font="THDRegular; 28" halign="right" backgroundColor="#000000" transparent="1">\n                                <convert type="ClockToText">Format:%d.%m.%Y</convert>\n                        </widget>\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/menu.png" zPosition="4" position="1062,634" size="80,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/red.png" zPosition="4" position="97,634" size="40,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/green.png" zPosition="4" position="309,634" size="40,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/yellow.png" zPosition="4" position="514,634" size="40,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/blue.png" zPosition="4" position="721,634" size="40,40" alphatest="blend" />\n                        <widget name="key_red" position="135,632" size="175,38"  zPosition="4" font="THDRegular2;20" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget name="key_green" position="342,637" size="164,26" zPosition="4" font="THDRegular2;20" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget name="key_yellow" position="546,627" size="164,26" zPosition="4" font="THDRegular2;20" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget name="key_blue" position="756,627" size="164,26" zPosition="4" font="THDRegular2;20" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget source="Title" render="Label" shadowColor="#000000" shadowOffset="3,2" position="141,57" zPosition="5" size="588,40" font="THDRegular; 28" backgroundColor="#000000" transparent="1" />\n                        '
        if config.plugins.zattoo.style.value == 'blue':
            skin += '\n                                <ePixmap position="0,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                                <ePixmap position="0,618" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                                <eLabel position="0,102" size="1280,519" zPosition="2" backgroundColor="#0b1a24" />\n                                <eLabel position="0,526" size="1280,97" zPosition="4" backgroundColor="#2d476f" />        \n                                </screen>'
        else:
            skin += '\n                                <ePixmap position="0,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlongBlack.png" transparent="1" />\n                                <ePixmap position="0,618" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlongBlack.png" transparent="1" />\n                                <eLabel position="0,102" size="1280,519" zPosition="2" backgroundColor="#111111" />\n                                <eLabel position="0,526" size="1280,97" zPosition="4" backgroundColor="#222222" />        \n                                </screen>'
    else:
        skin = '     \n                        <screen name="Zattoo Setup" position="0,0" size="1920,1080" title="Zattoo - Einstellungen" backgroundColor="transparent" flags="wfNoBorder" zPosition="10">\n                        <widget name="config" font="THDRegular2;31" itemHeight="70" position="18,109" size="1886,878" zPosition="15" transparent="1" scrollbarWidth="5" />\n                        <ePixmap position="45,30" zPosition="4" size="75,70" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/pic/zattoo.png" transparent="1" alphatest="blend" />\n                        <widget source="global.CurrentTime" render="Label" shadowColor="#000000" shadowOffset="3,2" zPosition="5" position="1710,55" size="103,50" font="THDRegular; 28" halign="right" backgroundColor="#000000" transparent="1">\n                                <convert type="ClockToText">Default</convert>\n                        </widget>\n                        <widget source="global.CurrentTime" render="Label" shadowColor="#000000" shadowOffset="3,2" zPosition="5" position="1529,55" size="43,30" font="THDRegular; 28" halign="left" backgroundColor="#000000" transparent="1">\n                                <convert type="ClockToText">Date</convert>\n                        </widget>\n                        <widget source="global.CurrentTime" render="Label" shadowColor="#000000" shadowOffset="3,2" zPosition="5" position="1567,55" size="157,50" font="THDRegular; 28" halign="right" backgroundColor="#000000" transparent="1">\n                                <convert type="ClockToText">Format:%d.%m.%Y</convert>\n                        </widget>\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/menu.png" zPosition="4" position="1438,995" size="80,40" alphatest="blend" />  \n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/red.png" zPosition="4" position="211,995" size="40,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/green.png" zPosition="4" position="483,995" size="40,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/yellow.png" zPosition="4" position="728,995" size="40,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/blue.png" zPosition="4" position="965,995" size="40,40" alphatest="blend" />\n                        <widget name="key_red" position="262,997" size="200,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget name="key_green" position="544,997" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget name="key_yellow" position="782,997" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget name="key_blue" position="1016,997" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget source="Title" render="Label" shadowColor="#000000" shadowOffset="3,2" position="141,57" zPosition="5" size="588,40" font="THDRegular; 28" backgroundColor="#000000" transparent="1" />\n                        '
        if config.plugins.zattoo.style.value == 'blue':
            skin += '\n                                <ePixmap position="0,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                                <ePixmap position="1280,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                                <ePixmap position="0,982" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                                <ePixmap position="1280,982" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                                <eLabel position="0,98" size="1920,895" zPosition="2" backgroundColor="#0b1a24" />       \n                                </screen>'
        else:
            skin += '\n                                <ePixmap position="0,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlongBlack.png" transparent="1" />\n                                <ePixmap position="1280,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlongBlack.png" transparent="1" />\n                                <ePixmap position="0,982" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlongBlack.png" transparent="1" />\n                                <ePixmap position="1280,982" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlongBlack.png" transparent="1" />\n                                <eLabel position="0,98" size="1920,895" zPosition="2" backgroundColor="#111111" />           \n                                </screen>'

    def __init__(self, session):
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ShortcutActions',
         'WizardActions',
         'ColorActions',
         'SetupActions',
         'NumberActions',
         'MenuActions',
         'EPGSelectActions'], {'cancel': self.keyCancel,
         'red': self.keyDelete,
         'green': self.keySave,
         'left': self.keyLeft,
         'right': self.keyRight}, -1)
        self['key_red'] = Label(_('Delete Picon/Path'))
        self['key_green'] = Label(_('Save'))
        self['key_yellow'] = Label(_(' '))
        self['key_blue'] = Label('')
        self.list = []
        self.createConfigList()
        ConfigListScreen.__init__(self, self.list)

    def createConfigList(self):
        self.list = []
        self.list.append(getConfigListEntry(_('Zattoo Username'), config.plugins.zattoo.username))
        self.list.append(getConfigListEntry(_('Zattoo Password'), config.plugins.zattoo.password))
        self.list.append(getConfigListEntry(_('Skin style'), config.plugins.zattoo.style))
        self.list.append(getConfigListEntry(_('Picon Storagepath'), config.plugins.zattoo.savepicon))
        self.list.append(getConfigListEntry(_('Local-Downloadpath'), config.plugins.zattoo.savedl))
        self.list.append(getConfigListEntry(_('Picon Color'), config.plugins.zattoo.picons))
        self.list.append(getConfigListEntry(_('Max. Streaming Bitrate'), config.plugins.zattoo.maxrate))
        self.list.append(getConfigListEntry(_('Show Channels'), config.plugins.zattoo.channels))

    def changedEntry(self):
        self.createConfigList()
        self['config'].setList(self.list)

    def keyLeft(self):
        ConfigListScreen.keyLeft(self)
        self.changedEntry()

    def keyRight(self):
        ConfigListScreen.keyRight(self)
        self.changedEntry()

    def keySave(self):
        config.plugins.zattoo.username.save()
        config.plugins.zattoo.password.save()
        config.plugins.zattoo.style.save()
        config.plugins.zattoo.picons.save()
        config.plugins.zattoo.maxrate.save()
        config.plugins.zattoo.channels.save()
        config.plugins.zattoo.savepicon.save()
        config.plugins.zattoo.savedl.save()
        configfile.save()
        self.close(True)

    def keyCancel(self):
        self.close(False)

    def keyDelete(self):
        import shutil
        if os.path.exists(config.plugins.zattoo.savepicon.value):
            shutil.rmtree(config.plugins.zattoo.savepicon.value)
            self.session.open(MessageBox, _('Zattoo Picons/Storagepath Removed !'), MessageBox.TYPE_INFO, timeout=6)
        else:
            self.session.open(MessageBox, _('No Picons/Storagepath found...\nPlease Restart Zattoo Plugin'), MessageBox.TYPE_INFO, timeout=6)


class zattooPlaylist(Screen):
    if screensize <= 720:
        skin = '\n\t\t        <screen name="ZattooPlaylist" position="0,0" size="1280,720" title=" " backgroundColor="transparent" flags="wfNoBorder" zPosition="10">\n                        <widget name="list" position="20,109" size="1220,476" zPosition="15" transparent="1" scrollbarWidth="5" />\n                        <ePixmap position="45,30" zPosition="4" size="75,70" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/pic/zattoo.png" transparent="1" alphatest="blend" />\n                        <widget source="global.CurrentTime" render="Label" shadowColor="#000000" shadowOffset="3,2" zPosition="5" position="1080,57" size="103,50" font="THDRegular; 28" halign="right" backgroundColor="#000000" transparent="1">\n                                <convert type="ClockToText">Default</convert>\n                        </widget>\n                        <widget source="global.CurrentTime" render="Label" shadowColor="#000000" shadowOffset="3,2" zPosition="5" position="897,57" size="43,30" font="THDRegular; 28" halign="left" backgroundColor="#000000" transparent="1">\n                                <convert type="ClockToText">Date</convert>\n                        </widget>\n                        <widget source="global.CurrentTime" render="Label" shadowColor="#000000" shadowOffset="3,2" zPosition="5" position="937,57" size="157,50" font="THDRegular; 28" halign="right" backgroundColor="#000000" transparent="1">\n                                <convert type="ClockToText">Format:%d.%m.%Y</convert>\n                        </widget>\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/menu.png" zPosition="4" position="1062,634" size="80,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/red.png" zPosition="4" position="97,634" size="40,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/green.png" zPosition="4" position="309,634" size="40,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/yellow.png" zPosition="4" position="514,634" size="40,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/blue.png" zPosition="4" position="721,634" size="40,40" alphatest="blend" />\n                        <widget name="key_red" position="135,637" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget name="key_green" position="342,637" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget name="key_yellow" position="546,637" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget name="key_blue" position="756,637" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />  \n                        <eLabel text="Zattoo - Aufnahmen" shadowColor="#000000" shadowOffset="3,2" position="141,57" zPosition="5" size="588,40" font="THDRegular; 28" backgroundColor="#000000" transparent="1" />\n                        '
        if config.plugins.zattoo.style.value == 'blue':
            skin += '\n                                <ePixmap position="0,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                                <ePixmap position="0,618" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                                <eLabel position="0,102" size="1280,519" zPosition="2" backgroundColor="#0b1a24" />       \n                                </screen>'
        else:
            skin += '\n                                <ePixmap position="0,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlongBlack.png" transparent="1" />\n                                <ePixmap position="0,618" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlongBlack.png" transparent="1" />\n                                <eLabel position="0,102" size="1280,519" zPosition="2" backgroundColor="#111111" />       \n                                </screen>'
    else:
        skin = '     \n                        <screen name="ZattooPlaylist" position="0,0" size="1920,1080" title=" " backgroundColor="transparent" flags="wfNoBorder" zPosition="10">\n                        <widget name="list" position="18,135" size="1886,810" zPosition="15" transparent="1" scrollbarWidth="5" />\n                        <ePixmap position="45,30" zPosition="4" size="75,70" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/pic/zattoo.png" transparent="1" alphatest="blend" />\n                        <widget source="global.CurrentTime" render="Label" shadowColor="#000000" shadowOffset="3,2" zPosition="5" position="1710,55" size="103,50" font="THDRegular; 28" halign="right" backgroundColor="#000000" transparent="1">\n                                <convert type="ClockToText">Default</convert>\n                        </widget>\n                        <widget source="global.CurrentTime" render="Label" shadowColor="#000000" shadowOffset="3,2" zPosition="5" position="1529,55" size="43,30" font="THDRegular; 28" halign="left" backgroundColor="#000000" transparent="1">\n                                <convert type="ClockToText">Date</convert>\n                        </widget>\n                        <widget source="global.CurrentTime" render="Label" shadowColor="#000000" shadowOffset="3,2" zPosition="5" position="1567,55" size="157,50" font="THDRegular; 28" halign="right" backgroundColor="#000000" transparent="1">\n                                <convert type="ClockToText">Format:%d.%m.%Y</convert>\n                        </widget>\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/menu.png" zPosition="4" position="1438,995" size="80,40" alphatest="blend" />  \n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/red.png" zPosition="4" position="211,995" size="40,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/green.png" zPosition="4" position="483,995" size="40,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/yellow.png" zPosition="4" position="728,995" size="40,40" alphatest="blend" />\n                        <ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/buttons/blue.png" zPosition="4" position="965,995" size="40,40" alphatest="blend" />\n                        <widget name="key_red" position="275,997" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget name="key_green" position="544,997" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget name="key_yellow" position="782,997" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <widget name="key_blue" position="1016,997" size="164,26" zPosition="4" font="THDRegular2;22" halign="left" backgroundColor="#000000" transparent="1" valign="center" />\n                        <eLabel text="Zattoo - Aufnahmen" shadowColor="#000000" shadowOffset="3,2" position="141,57" zPosition="5" size="588,40" font="THDRegular; 28" backgroundColor="#000000" transparent="1" />\n                        '
        if config.plugins.zattoo.style.value == 'blue':
            skin += '\n                                <ePixmap position="0,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                                <ePixmap position="1280,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                                <ePixmap position="0,982" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                                <ePixmap position="1280,982" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlong.png" transparent="1" />\n                                <eLabel position="0,98" size="1920,895" zPosition="2" backgroundColor="#0b1a24" />       \n                                </screen>'
        else:
            skin += '\n                                <ePixmap position="0,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlongBlack.png" transparent="1" />\n                                <ePixmap position="1280,44" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlongBlack.png" transparent="1" />\n                                <ePixmap position="0,982" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlongBlack.png" transparent="1" />\n                                <ePixmap position="1280,982" zPosition="3" size="1280,59" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/menu/borderlongBlack.png" transparent="1" />\n                                <eLabel position="0,98" size="1920,895" zPosition="2" backgroundColor="#111111" />           \n                                </screen>'

    def __init__(self, session):
        from enigma import addFont
        addFont('/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/font/technihd.ttf', 'THDRegular', 100, 1)
        addFont('/usr/lib/enigma2/python/Plugins/Extensions/zattoo/skins/TechniHD/font/technihd2.ttf', 'THDRegular2', 100, 1)
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ShortcutActions',
         'WizardActions',
         'ColorActions',
         'SetupActions',
         'NumberActions',
         'MenuActions',
         'EPGSelectActions',
         'InfobarInstantRecord'], {'cancel': self.keyCancel,
         'red': self.keyRemoveRecording,
         'green': self.reloadlist,
         'menu': self.keyMainMenu,
         'ok': self.keyOk,
         'up': self.keyUp,
         'down': self.keyDown,
         'nextBouquet': self.keyUp,
         'prevBouquet': self.keyDown,
         'left': self.keyLeft,
         'right': self.keyRight,
         'yellow': self.listSort,
         'instantRecord': self.keyRecord,
         'blue': self.keySetup}, -1)
        self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
        if screensize <= 720:
            font1, size1 = skin.parameters.get('ZattooListFont1', ('THDRegular', 24))
            font2, size2 = skin.parameters.get('ZattooListFont2', ('THDRegular2', 21))
            font3, size3 = skin.parameters.get('ZattooListFont3', ('THDRegular2', 20))
            self.itemheight = int(skin.parameters.get('ZattooListItemHeight', (59,))[0])
            self.listwidth = int(skin.parameters.get('ZattooListWidth', (450,))[0])
        else:
            font1, size1 = skin.parameters.get('ZattooListFont1', ('THDRegular', 33))
            font2, size2 = skin.parameters.get('ZattooListFont2', ('THDRegular2', 29))
            font3, size3 = skin.parameters.get('ZattooListFont3', ('THDRegular2', 22))
            self.itemheight = int(skin.parameters.get('ZattooListItemHeight', (90,))[0])
            self.listwidth = int(skin.parameters.get('ZattooListWidth', (600,))[0])
        self.chooseMenuList.l.setFont(0, gFont(font1, int(size1)))
        self.chooseMenuList.l.setFont(1, gFont(font2, int(size2)))
        self.chooseMenuList.l.setFont(2, gFont(font3, int(size3)))
        self.chooseMenuList.l.setItemHeight(self.itemheight)
        self.chooseMenuList.selectionEnabled(False)
        self['info'] = Label('Info')
        self['list'] = self.chooseMenuList
        self['key_red'] = Label(_('Delete REC'))
        self['key_green'] = Label(_('Reload List'))
        self['key_blue'] = Label(_('Setup'))
        self['key_yellow'] = Label(_('Normal'))
        self.list = []
        self.extended = []
        self.lastservice = self.session.nav.getCurrentlyPlayingServiceReference()
        self.title = 'Zattoo - Aufnahmen'
        self.login = False
        self.playing = False
        self.zapi = ZapiSession('/usr/lib/enigma2/python/Plugins/Extensions/zattoo/')
        self.AccountData = None
        self.showlist = False
        self.eventInfos = False
        self.onClose.append(self.__onClose)
        self.onLayoutFinish.append(self.dologin)
        return

    def setinfo(self, txt):
        self['info'].setText(txt)

    def setInfoBar(self):
        exist = self['list'].getCurrent()
        if exist == None:
            return
        else:
            return

    def dologin(self):
        self.setinfo('Login...!')
        if not pathExists(config.plugins.zattoo.savepicon.value):
            os.makedirs(config.plugins.zattoo.savepicon.value)
        if config.plugins.zattoo.username.value == '' and config.plugins.zattoo.password.value == '':
            self.setinfo('Bitte > MENU < dr\xc3\xbccken und Login daten eingeben.')
        else:
            self.login = self.zapi.init_session(config.plugins.zattoo.username.value, config.plugins.zattoo.password.value)
            if self.login:
                try:
                    self.setinfo('Login ok !')
                    self.AccountData = self.zapi.get_accountData()
                    api = '/zapi/v2/cached/channels/' + self.AccountData['session']['power_guide_hash'] + '?details=True'
                    api2 = '/zapi/playlist'
                    channelsData = self.zapi.exec_zapiCall(api, None)
                    playlist = self.zapi.exec_zapiCall(api2, None)
                    if channelsData:
                        if playlist:
                            for each in playlist['recordings']:
                                bchname = str(each['title'])
                                if bchname is not None:
                                    chname = bchname
                                    description = str(each['episode_title'])
                                    year = str(each['position'])[0:4]
                                    month = str(each['position'])[5:7]
                                    day = str(each['position'])[8:10]
                                    date = '  ' + day + '.' + month + '.' + year + ' '
                                    cid = str(each['id'])
                                    if description == 'None':
                                        episode = _('No description available.')
                                    else:
                                        episode = description
                                    logoname = str(each['cid'])
                                    logopath = config.plugins.zattoo.savepicon.value + logoname + '.png'
                                    start = str(each['start'])
                                    end = str(each['end'])
                                    cstart = datetime.datetime.strptime(start, '%Y-%m-%dT%H:%M:%SZ')
                                    time = str(cstart)
                                    begin = datetime.datetime.strptime(start, '%Y-%m-%dT%H:%M:%SZ') + timedelta(hours=2)
                                    ende = datetime.datetime.strptime(end, '%Y-%m-%dT%H:%M:%SZ') + timedelta(hours=2)
                                    fixtime = str(begin)[11:16] + ' - ' + str(ende)[11:16]
                                    fixname = chname.replace(' ', '_').replace('-', '_')
                                    picurl = str(each['image_url'])
                                    imageurl = picurl.replace('format_480x360', 'format_40x30')
                                    episodefix = episode.replace('/', '_')
                                    imagepath = config.plugins.zattoo.savepicon.value + 'Recording_' + fixname + '-' + episodefix + '.jpg'
                                    if not fileExists(imagepath):
                                        downloadPage(str(imageurl), imagepath)
                                        self.list.append((chname,
                                         logopath,
                                         episode,
                                         date,
                                         cid,
                                         time,
                                         fixtime,
                                         imagepath))
                                    else:
                                        self.list.append((chname,
                                         logopath,
                                         episode,
                                         date,
                                         cid,
                                         time,
                                         fixtime,
                                         imagepath))

                        self.chooseMenuList.setList(map(self.showList, self.list))
                        self.showlist = True
                except:
                    self.setinfo('Plugin Entwickler kontaktieren !')

            else:
                self.setinfo('Login failed !')
        return

    def getHours(self, unixtime):
        return datetime.datetime.fromtimestamp(int(unixtime)).strftime('%Y-%m-%dT%H:%M:%SZ')

    def showList(self, entry):
        chname, logopath, episode, date, cid, time, fixtime, imagepath = entry
        callback = [entry]
        start = datetime.datetime.now().strftime('%Y-%m-%dT%H:%M:%SZ')
        nowtime = str(start)
        if fileExists(entry[1]):
            logo = loadPNG(entry[1])
            callback.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND,
             10,
             (self.itemheight - 44) / 3,
             100,
             self.itemheight,
             logo))
        if time > start:
            color = parseColor('#00636363').argb()
            if screensize <= 720:
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 140,
                 5,
                 920,
                 self.itemheight / 2,
                 0,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[0],
                 color))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 1050,
                 5,
                 300,
                 self.itemheight / 2,
                 0,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[3],
                 color))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 1050,
                 30,
                 300,
                 self.itemheight / 2,
                 1,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[6],
                 color))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 140,
                 32,
                 920,
                 self.itemheight / 2,
                 1,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[2],
                 color))
                if fileExists(entry[7]):
                    image = LoadPixmap('/usr/lib/enigma2/python/Plugins/Extensions/zattoo/pic/key.png')
                    callback.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND,
                     980,
                     (self.itemheight - 40) / 3,
                     100,
                     self.itemheight,
                     image))
            else:
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 140,
                 5,
                 1750,
                 self.itemheight / 2,
                 0,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[0],
                 color))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 1650,
                 5,
                 300,
                 self.itemheight / 2,
                 0,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[3],
                 color))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 1650,
                 35,
                 300,
                 self.itemheight / 2,
                 1,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[6],
                 color))
                callback.append((eListboxPythonMultiContent.TYPE_TEXT,
                 140,
                 40,
                 1750,
                 self.itemheight / 2,
                 1,
                 RT_HALIGN_LEFT | RT_VALIGN_CENTER,
                 entry[2],
                 color))
                if fileExists(entry[7]):
                    image = LoadPixmap('/usr/lib/enigma2/python/Plugins/Extensions/zattoo/pic/key.png')
                    callback.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND,
                     1579,
                     (self.itemheight - 22) / 3,
                     100,
                     self.itemheight,
                     image))
        elif screensize <= 720:
            color = parseColor('#00fabe4b').argb()
            callback.append((eListboxPythonMultiContent.TYPE_TEXT,
             140,
             5,
             750,
             self.itemheight / 2,
             0,
             RT_HALIGN_LEFT | RT_VALIGN_CENTER,
             entry[0]))
            callback.append((eListboxPythonMultiContent.TYPE_TEXT,
             1050,
             5,
             300,
             self.itemheight / 2,
             0,
             RT_HALIGN_LEFT | RT_VALIGN_CENTER,
             entry[3]))
            callback.append((eListboxPythonMultiContent.TYPE_TEXT,
             1050,
             30,
             300,
             self.itemheight / 2,
             1,
             RT_HALIGN_LEFT | RT_VALIGN_CENTER,
             entry[6],
             color))
            callback.append((eListboxPythonMultiContent.TYPE_TEXT,
             140,
             32,
             750,
             self.itemheight / 2,
             1,
             RT_HALIGN_LEFT | RT_VALIGN_CENTER,
             entry[2],
             color))
            if fileExists(entry[7]):
                image = LoadPixmap(entry[7])
                callback.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND,
                 960,
                 (self.itemheight - 44) / 3,
                 100,
                 self.itemheight,
                 image))
        else:
            color = parseColor('#00fabe4b').argb()
            callback.append((eListboxPythonMultiContent.TYPE_TEXT,
             140,
             5,
             1750,
             self.itemheight / 2,
             0,
             RT_HALIGN_LEFT | RT_VALIGN_CENTER,
             entry[0]))
            callback.append((eListboxPythonMultiContent.TYPE_TEXT,
             1650,
             5,
             300,
             self.itemheight / 2,
             0,
             RT_HALIGN_LEFT | RT_VALIGN_CENTER,
             entry[3]))
            callback.append((eListboxPythonMultiContent.TYPE_TEXT,
             1650,
             35,
             300,
             self.itemheight / 2,
             1,
             RT_HALIGN_LEFT | RT_VALIGN_CENTER,
             entry[6],
             color))
            callback.append((eListboxPythonMultiContent.TYPE_TEXT,
             140,
             40,
             1750,
             self.itemheight / 2,
             1,
             RT_HALIGN_LEFT | RT_VALIGN_CENTER,
             entry[2],
             color))
            if fileExists(entry[7]):
                image = LoadPixmap(entry[7])
                callback.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND,
                 1560,
                 (self.itemheight - 20) / 9,
                 100,
                 self.itemheight,
                 image))
        return callback

    def __onClose(self):
        None
        return

    def keyRemoveRecording(self):
        id = self['list'].getCurrent()[0][4]
        remove_recording = self.zapi.exec_zapiCall('/zapi/playlist/remove', {'recording_id': id})
        if remove_recording:
            self.session.open(MessageBox, _('Zattoo >> Aufnahme entfernt <<'), MessageBox.TYPE_INFO, timeout=8)
            self.reloadlist()

    def sortMode(self):
        if config.plugins.zattoo.abc.value == 'normal':
            config.plugins.zattoo.abc.set('az')
        else:
            config.plugins.zattoo.abc.set('normal')
        self.listSort()

    def listSort(self):
        self.listbackup = self.list
        if len(self.list) > 0:
            if config.plugins.zattoo.abc.value == 'normal':
                self['key_yellow'].setText(_('Normal'))
                self.chooseMenuList.setList(map(self.showList, self.listbackup))
                self.chooseMenuList.moveToIndex(0)
            else:
                self.list.sort(key=lambda x: x[0])
                self['key_yellow'].setText(_('A-Z'))
                self.chooseMenuList.setList(map(self.showList, self.list))
                self.chooseMenuList.moveToIndex(0)
    
    def keyRecord(self):
        #try:
          #  if os.path.exists('/usr/bin/ffmpeg'):
		title = self['list'].getCurrent()[0][0]
		id = self['list'].getCurrent()[0][4]
		description = self['list'].getCurrent()[0][2]
		date = self['list'].getCurrent()[0][3]
		stream = self.zapi.exec_zapiCall('/zapi/watch', {'recording_id': id, 'stream_type': 'hls7', 'maxrate':(config.plugins.zattoo.maxrate.value)})
		stream_url = stream['stream']['watch_urls'][0]['url']
		
		title2 = str(title).replace(' ', '_').replace("'", '_')
		description2 = str(description).replace(' ', '_').replace("'", '_')
		date2 = str(date).replace(' ', '')
		chname = title2 + '_-_' + description2 + '-' + date2 + '.mp4'
		cmd = 'ffmpeg -i ' + str(stream_url) + ' -c copy -y ' + str(config.plugins.zattoo.savedl.value) + chname
		container = eConsoleAppContainer()
		container.execute(cmd)
		self.session.open(MessageBox, _('Zattoo >> Download gestartet... <<'), MessageBox.TYPE_INFO, timeout=8)

    def keyMainMenu(self):
        from Screens.Menu import MainMenu
        from Tools.Directories import resolveFilename, SCOPE_SKIN
        import xml.etree.cElementTree
        mdom = xml.etree.cElementTree.parse(resolveFilename(SCOPE_SKIN, 'menu.xml'))
        menu = mdom.getroot()
        self.session.open(MainMenu, menu)

    def keyLeft(self):
        if self.eventInfos == True:
            self['extended'].pageUp()
        if self.showlist:
            self['list'].pageUp()
            if self.eventInfos == False:
                self.setInfoBar()
        else:
            self.showlist = True
            self.show()

    def keyRight(self):
        if self.eventInfos == True:
            self['extended'].pageDown()
        if self.showlist:
            self['list'].pageDown()
            if self.eventInfos == False:
                self.setInfoBar()
        else:
            self.showlist = True
            self.show()

    def switch(self):
        chname = self['list'].getCurrent()[0][0]
        id = self['list'].getCurrent()[0][1]
        stream = self.zapi.exec_zapiCall('/zapi/watch', {'cid': id,
         'stream_type': 'hls7',
         'maxrate': config.plugins.zattoo.maxrate.value})
        print stream
        try:
            stream_url = stream['stream']['watch_urls'][0]['url']
            stream_url2 = stream_url.replace('-hls7', '-hls5')
            print stream_url
            self.session.nav.stopService()
            sref = eServiceReference(4097, 2, str(stream_url2))
            sref.setName(chname)
            self.setTitle(chname)
            self.session.nav.playService(sref)
            self.playing = True
            self.showlist = False
            self.hide()
        except:
            self.setTitle('Sender nicht gebucht !')

    def keyUp(self):
        if self.eventInfos == True:
            self['extended'].pageUp()
        if self.showlist:
            self['list'].up()
            if self.eventInfos == False:
                self.setInfoBar()
        else:
            chname = self['list'].down()
            self.switch()

    def keyDown(self):
        if self.eventInfos == True:
            self['extended'].pageDown()
        if self.showlist:
            self['list'].down()
            if self.eventInfos == False:
                self.setInfoBar()
        else:
            chname = self['list'].up()
            self.switch()

    def keyOk(self):
        exist = self['list'].getCurrent()
        if exist == None:
            return
        else:
            if self.showlist:
                title = self['list'].getCurrent()[0][0]
                id = self['list'].getCurrent()[0][4]
                description = self['list'].getCurrent()[0][2]
                date = self['list'].getCurrent()[0][3]
                chname = title + ' - ' + description + ' (' + date + ')'
                stream = self.zapi.exec_zapiCall('/zapi/watch', {'recording_id': id,
                 'stream_type': 'hls7',
                 'maxrate': config.plugins.zattoo.maxrate.value})
                print stream
                try:
                    stream_url = stream['stream']['watch_urls'][0]['url']
                    stream_url2 = stream_url.replace('-hls7', '-hls5')
                    #print stream_url
                    self.session.nav.stopService()
                    sref = eServiceReference(4097, 1, str(stream_url2))
                    sref.setName(chname)
                    self.setTitle(chname)
                    self.session.open(MoviePlayer, sref)
                    self.playing = True
                    self.showlist = False
                    self.hide()
                except:
                    self.setinfo('Sender nicht gebucht !')

            else:
                self.show()
                self.showlist = True
                self.session.nav.stopService()
                self.session.nav.playService(self.lastservice)
            return

    def keySetup(self):
        self.session.openWithCallback(self.relogin, zattooSetup)

    def relogin(self, answer):
        print answer
        if answer:
            self.dologin()

    def reloadlist(self):
        if self.showlist:
            self.list = []
            self.dologin()
        else:
            self.list = []
            self.dologin()
            self.showlist = False

    def keyCancel(self):
        if self.eventInfos == True:
            self.eventInfos = False
            self['extended'].setText('')
            self['list'].show()
            self['extended'].hide()
            self['cover'].hide()
            self.show()
            self.showlist = True
            return
        if self.showlist and self.playing:
            if self.eventInfos == True:
                self.eventInfos = False
                self['extended'].setText('')
                self['list'].show()
                self['extended'].hide()
                self['cover'].hide()
                self.show()
                self.showlist = True
                return
            else:
                self.hide()
                self.showlist = False
                return
        if self.playing:
            self.session.nav.stopService()
            self.session.nav.playService(self.lastservice)
            self.playing = False
            self.show()
            self.showlist = True
            return
        self.close()
        