# coding=utf-8

#
# 	 ZapiSession
# 	(c) 2014 Pascal Nançoz
# 	modified by Daniel Griner
#


import os, re, base64
import urllib, urllib2
import json
import uuid

class ZapiSession:
	ZAPI_AUTH_URL = 'https://zattoo.com'
	ZAPI_URL = 'https://zattoo.com'
	DATA_FOLDER = None
	COOKIE_FILE = None
	ACCOUNT_FILE = None
	SESSION_FILE = None
	HttpHandler = None
	Username = None
	Password = None
	AccountData = None
	SessionData = None

	def __init__(self, dataFolder):
		self.DATA_FOLDER = dataFolder
		self.COOKIE_FILE = os.path.join(dataFolder, 'cookie.cache')
		self.ACCOUNT_FILE = os.path.join(dataFolder, 'account.cache')
		self.APICALL_FILE = os.path.join(dataFolder, 'apicall.cache')
		self.SESSION_FILE = os.path.join(dataFolder, 'session.cache')
		self.HttpHandler = urllib2.build_opener()
		self.HttpHandler.addheaders = [('Content-type', 'application/x-www-form-urlencoded'), ('Accept', 'application/json')]

	def init_session(self, username, password, api_url="https://zattoo.com"):
		self.Username = username
		self.Password = password
		self.ZAPI_URL = api_url
		if self.restore_session():
		    #debug ('Restore = '+str(self.restore_session()))
		    return self.restore_session() 
		else: 
                    return self.renew_session()
		

	def restore_session(self):
		if os.path.isfile(self.COOKIE_FILE) and os.path.isfile(self.ACCOUNT_FILE) and os.path.isfile(self.SESSION_FILE):
                #if os.path.isfile(self.COOKIE_FILE) and os.path.isfile(self.ACCOUNT_FILE):
			with open(self.ACCOUNT_FILE, 'r') as f:
				accountData = json.loads(base64.b64decode(f.readline()))
				print accountData
			if accountData['success'] == True:
				self.AccountData = accountData
				#self.SessionData = str(sessionData)
				with open(self.COOKIE_FILE, 'r') as f:
					self.set_cookie(base64.b64decode(f.readline()))
				with open(self.SESSION_FILE, 'r') as f:
				        #self.SessionData = str(sessionData)
					sessionData = json.loads(base64.b64decode(f.readline()))
					self.SessionData = str(sessionData)
				return True

		return False

	def extract_sessionId(self, cookieContent):
		if cookieContent is not None:
			return re.search("beaker\.session\.id\s*=\s*([^\s;]*)", cookieContent).group(1)
		return None
	
	def get_accountData(self):
		accountData={}
		if os.path.isfile(self.ACCOUNT_FILE):
			with open(self.ACCOUNT_FILE, 'r') as f:
				accountData = json.loads(base64.b64decode(f.readline()))
		return accountData

	def persist_accountData(self, accountData):
		with open(self.ACCOUNT_FILE, 'w') as f:
			f.write(base64.b64encode(json.dumps(accountData)))

	def persist_sessionId(self, sessionId):
		with open(self.COOKIE_FILE, 'w') as f:
			f.write(base64.b64encode(sessionId))

	def persist_sessionData(self, sessionData):
		with open(self.SESSION_FILE, 'w') as f:
			f.write(base64.b64encode(json.dumps(sessionData)))
			
        def set_cookie(self, sessionId):
		self.HttpHandler.addheaders.append(('Cookie', 'beaker.session.id=' + sessionId))

	def request_url(self, url, params):
		try:
			response = self.HttpHandler.open(url, urllib.urlencode(params) if params is not None else None)
			print response
			if response is not None:
				sessionId = self.extract_sessionId(response.info().getheader('Set-Cookie'))
				if sessionId is not None:
					self.set_cookie(sessionId)
					self.persist_sessionId(sessionId)
				return response.read()
		except Exception:
			pass
		return None

	# zapiCall with params=None creates GET request otherwise POST

	def exec_zapiCall(self, api, params, context='default'):
		url = self.ZAPI_AUTH_URL + api if context == 'session' else self.ZAPI_URL + api
		content = self.request_url(url, params)
		print content
		if content is None and context != 'session' and self.renew_session():
			content = self.request_url(url, params)
		if content is None:
			return None
		try:
			resultData = json.loads(content)
			if resultData['success'] == True:
				return resultData
		except Exception:
			pass
		return None
		
        def ORIG_exec_zapiCall(self, api, params, context='default'):
		url = self.ZAPI_URL + api
		content = self.request_url(url, params)
		if content is None:# and self.renew_session():
			content = self.request_url(url, params)
		if content is None:
			return None
		try:
			resultData = json.loads(content)
			return resultData
		except Exception:
			pass
		return None

	def fetch_appToken(self):
		handle = urllib2.urlopen(self.ZAPI_URL + '/token-46a1dfccbd4c3bdaf6182fea8f8aea3f.json?id=ZvOj-NPFWKOPEAg57jBkU')
		html = json.loads(handle.read())
		return html['session_token']
    #handle = urllib2.urlopen(self.ZAPI_URL + '/int/')
		#html = handle.read()
		#return re.search("window\.appToken\s*=\s*'(.*)'", html).group(1)
		
	def session(self):
		api = '/zapi/session/hello'
		params = {"client_app_token" : self.fetch_appToken(),
				  "uuid"    : "d7512e98-38a0-4f01-b820-5a5cf98141fe",
          "lang"    : "en",
          "format"  : "json"}
		sessionData = self.exec_zapiCall(api, params, 'session')
		#debug('SessionData: '+str(sessionData))
		if sessionData is not None:
			self.SessionData = sessionData
			self.persist_sessionData(sessionData)
			return True
		return False
		
        def login(self):
		api = '/zapi/v2/account/login'
		params = {"login": self.Username, "password" : self.Password}
		accountData = self.exec_zapiCall(api, params, 'session')
		#print accountData 
		if accountData is not None:
			self.AccountData = accountData
			self.persist_accountData(accountData)
			return True
		return False

	def renew_session(self):
		return self.session() and self.login()
